<?
###########################################################################
# Dawgclan Network Downloader v1.03 by Rothgar (2003/04/22).
# (c)2003-2004 Dawgclan Network. All Rights Reserved.
# You can freely use or modify the script, as long as this message is kept
# intact in the source.
#
# Contact my via:
# e-mail: admin@dawgclan.net
# ICQ: 48569749
# website: http://www.dawgclan.net
###########################################################################

//Specify download directory and create path variables.
//Post: $dl_dir must be the directory containing files.
//	$dl_path and $script_url may have to be changed on some hosts.
$dl_dir = '/files/';

//Should be created Automatically.
//Post: May not work for subdomains, $script_url should be full url to $dl_dir.
//	$dl_path should be internal directory path to $dl_dir
$dl_path = $_SERVER['DOCUMENT_ROOT'] . $dl_dir;
$script_url = 'http://' . $_SERVER['HTTP_HOST'] . $dl_dir;

//Specify the statistic file containing the download information.
//Post: Must be inside the download directory.
$logfile = $dl_path . 'stats.txt';
$fileinfo = file($logfile);

//Load all data into the array
$downloads;
for ($i=0; $i<count($fileinfo); $i++)
	$downloads[$i] = explode("|", trim($fileinfo[$i]));

//Statistic page function.
function Viewstats(&$downloads, &$dl_path, &$filedir) {
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $filedir . "style.css\" />\n";
	echo "<table cellspacing=\"0\" class=\"dlmain\">\n";
	echo "  <tr class=\"dlheader\">\n    <th>Date</th>\n    <th>Name</th>\n    <th>Size (KB)</th>\n    <th>Author</th>\n    <th>Downloads</th>\n  </tr>\n";
	for ($Row=0; $Row<count($downloads); $Row++) {
		echo "  <tr>\n";
		echo "    <td>" . $downloads[$Row][1] . "</td>\n";
		if ($downloads[$Row][2] != $null)
			echo "    <td><a href=\"" . $downloads[$Row][2] . "\">" . $downloads[$Row][3] . "</a></td>\n";
		else
			echo "    <td>" . $downloads[$Row][3] . "</td>\n";
		echo "    <td>" . round(filesize($dl_path . $downloads[$Row][4]) / 1024,0) . "</td>\n";
		if ($downloads[$Row][5] != $null)
			echo "    <td><a href=\"mailto:" . $downloads[$Row][5] . "\">" . $downloads[$Row][6] . "</a></td>\n";
		else
			echo "    <td>" . $downloads[$Row][6] . "</td>\n";
		echo "    <td>" . $downloads[$Row][7] . "</td>\n";
		echo "  </tr>\n";
	}
	for ($i=0; $i<count($downloads); $i++)
		$total += $downloads[$i][7];
	echo "  <tr>\n    <td colspan=\"4\" align=\"right\">Total</td>\n    <td>" . $total . "</td>\n  </tr>\n";
	echo "  <tr>\n    <td colspan=\"4\" align=\"right\">Average</td>\n    <td>" . round($total/count($downloads),0) . "</td>\n  </tr>\n";
	echo "</table>\n";
}

//Download table function.
function ListDownloads(&$downloads, &$dl_path, &$params, &$request_url, &$filedir) {
	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $filedir . "style.css\" />\n";
	echo "<table cellspacing=\"0\" class=\"dlmain\">\n";
	echo "  <tr class=\"dlheader\">\n    <th>Date</th>\n    <th>Name</th>\n    <th>Size (KB)</th>\n    <th>Author</th>\n    <th>Code</th>\n    <th>Downloads</th>\n  </tr>\n";
	for ($Row=0; $Row<count($downloads); $Row++) {
		echo "  <tr>\n";
		echo "    <td>" . $downloads[$Row][1] . "</td>\n";
		if ($downloads[$Row][2] != $null)
			echo "    <td><a href=\"" . $downloads[$Row][2] . "\">" . $downloads[$Row][3] . "</a></td>\n";
		else
			echo "    <td>" . $downloads[$Row][3] . "</td>\n";
		echo "    <td>" . round(filesize($dl_path . $downloads[$Row][4]) / 1024,0) . "</td>\n";
		if ($downloads[$Row][5] != $null)
			echo "    <td><a href=\"mailto:" . $downloads[$Row][5] . "\">" . $downloads[$Row][6] . "</a></td>\n";
		else
			echo "    <td>" . $downloads[$Row][6] . "</td>\n";
		if ($params != $null)
			echo "    <td><a href=\"" . $request_url . "&dload=" . $downloads[$Row][0] . "\">Download</a></td>\n";
		else
			echo "    <td><a href=\"" . $request_url . "?dload=" . $downloads[$Row][0] . "\">Download</a></td>\n";
		echo "    <td>" . $downloads[$Row][7] . "</td>\n";
		echo "  </tr>\n";
	}
	if ($params != $null)
		echo "  <tr>\n    <td colspan=\"6\" align=\"right\"><a href=\"" . $request_url . "&stat=view\">View Stat Page</a></td>\n  </tr>\n";
	else
		echo "  <tr>\n    <td colspan=\"6\" align=\"right\"><a href=\"" . $request_url . "?stat=view\">View Stat Page</a></td>\n  </tr>\n";
	echo "</table>\n";
}

//Retrieve file for client.
function GetFile(&$downloads, &$dload, &$logfile, &$filedir) {
	
	$downloads[$dload-1][7]++;
	//Re-write File
	if (is_writeable($logfile)) {
		$file = fopen($logfile, 'w');
		for ($Row=0; $Row<count($downloads); $Row++) {
			for ($Col=0; $Col<count($downloads[$Row]); $Col++) {
				fwrite($file, $downloads[$Row][$Col]);
				if ($Col != count($downloads[$Row])-1)
					fwrite($file, '|');
			}
			if ($Row != count($downloads)-1)
				fwrite($file, "\r\n");
		}
		fclose($file);
		header("Location: " . $filedir . $downloads[$dload-1][4]);
		exit;
	}
	else
		die("Bad CHMOD on log file.");
}

//Check which function to initiate.
function RetrieveDownloads() {
	//Query header for params.
	$stat = $_GET['stat'];
	//Specify global variables.
	global $dl_path, $script_url, $logfile, $fileinfo, $downloads;

	//$logfile = $dl_path . 'stats.txt';
	//$fileinfo = file($logfile);

	//Load all data into the array
	//$downloads;
	//for ($i=0; $i<count($fileinfo); $i++)
	//	$downloads[$i] = explode("|", trim($fileinfo[$i]));

	if (($stat != $null) && ($stat == view))
		ViewStats($downloads, $dl_path, $script_url);
	else
		ListDownloads($downloads, $dl_path, $_SERVER['QUERY_STRING'], $_SERVER['REQUEST_URI'], $script_url);
}

$dload = $_GET['dload'];
if ($dload != $null)
	if (($dload > 0) && ($dload <= count($downloads)))
		GetFile($downloads, $dload, $logfile, $script_url);
	else
		die("File Does Not Exist.");
?>